<?php

namespace App\Exports;

use App\Models\ClassRoom;
use App\Models\StudentSubscribe;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class RoomAttendanceExport implements
 FromView,
 ShouldAutoSize,
 WithEvents
{
    use Exportable;
    private $roomId;
    public function __construct( $roomId)
    {
        $this->roomId = $roomId;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    // public function collection()
    // {
    //     return ClassRoom::all();
    // }
    public function view():View
    {
         $rooms = StudentSubscribe::where('room_id',$this->roomId)->get()->map(function ($item) {
            $presents = 0;
            $absents = 0;

            // count lessons for each room
            $item->lessonsCount = $item->room->course->lessons->count();

            // count students for each room
            // $item->studentsCount = $item->room->students->count();

            // foreach fro count present students in every attendance for each room
            $presents += $item->attendances
                ->map(function ($item) {
                    if ($item->is_present == 1)
                        return $item;
                })->reject(function ($item) {
                    return empty($item);
                })->count();

            // foreach fro count absent students in every attendance for each room
            $absents += $item->attendances
                ->map(function ($item) {
                    if ($item->is_present == -1)
                        return $item;
                })->reject(function ($item) {
                    return empty($item);
                })->count();

            // put attendance values in room
            $item->presentsCount = $presents;
            $item->absentsCount = $absents;
            if ($item->lessonsCount > 0) {

                $item->presentsPercentage = $presents / ($item->lessonsCount) * 100;
                $item->absentsPercentage = $absents / ($item->lessonsCount) * 100;
                $item->notAttendantPercentage = 100 - ($item->presentsPercentage + $item->absentsPercentage);
            }
            return $item;
        });
        $arrayDays = [
            'Sun'=>'الأحد',
            'Mon'=>'الإثنين',
            'Tue'=>'الثلاثاء',
            'Wed'=>'الأربعاء',
            'Thu'=>'الخميس',
            'Fri'=>'الجمعة',
            'Sat'=>'السبت'
        ];
        return view('exports.attendances-room',[
                'rooms'=>$rooms,
                'arrayDays'=>$arrayDays
        ]);
        // return ClassRoom::all();
    }

public function registerEvents(): array
{
    return [
                BeforeSheet::class  =>function(BeforeSheet $event){
                        $event->getDelegate()->setRightToLeft(true);
                    },
                AfterSheet::class =>function (AfterSheet $event)
                {
                    $event->sheet->getStyle('A1:I1')->applyFromArray([
                        'font'=>[
                            'bold'=>true
                        ]
                    ]);
                }
                
    ] ;
    }
}
